<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined('ABSPATH') || exit;

global $product;

if (empty($product) || !($product instanceof WC_Product) || !$product->is_visible()) {
    return;
}

if (has_excerpt()) {
    add_filter('excerpt_length', 'studiare_product_custom_excerpt_length', 999);
}

$prefix = '_studiare_';
$post_id = get_the_ID();
$meta_keys = [
    'course_teachers',
    'course_teacher', 'course_teacher_2', 'course_teacher_3', 'course_teacher_4',
    'course_duration', 'course_duration_hint', 'sc_course_type_selector',
    'sc_course_type_title_1', 'sc_course_type_title_2', 'sc_loop_main_feature',
    'sc_loop_main_feature_hint', 'sc_loop_main_feature_icon', 'course_buyers_text_hint',
    'course_buyers_text_icon'
];
$meta_data = [];
foreach ($meta_keys as $key) {
    $meta_data[$key] = get_post_meta($post_id, $prefix . $key, true);
}

$sale_price = $product->get_sale_price();
$regular_price = $product->get_regular_price();

$teachers = [];
if (!empty($meta_data['course_teachers']) && is_array($meta_data['course_teachers'])) {
    $teachers = $meta_data['course_teachers'];
} else {
    $old_teachers = array_filter([
        $meta_data['course_teacher'],
        $meta_data['course_teacher_2'],
        $meta_data['course_teacher_3'],
        $meta_data['course_teacher_4']
    ], function($id) {
        return !empty($id) && $id !== 'no-teacher';
    });
    $teachers = array_unique($old_teachers);
}

$stock = get_post_meta($post_id, '_stock', true);
$duration = $meta_data['course_duration'];
$duration_hint = $meta_data['course_duration_hint'] ?: 'مدت زمان آموزش';
$sc_course_type_selector = $meta_data['sc_course_type_selector'];
$sc_course_type_title_1 = $meta_data['sc_course_type_title_1'];
$sc_course_type_title_2 = $meta_data['sc_course_type_title_2'];
$sc_loop_main_feature = $meta_data['sc_loop_main_feature'];
$sc_loop_main_feature_hint = $meta_data['sc_loop_main_feature_hint'];
$sc_loop_main_feature_icon = $meta_data['sc_loop_main_feature_icon'];
$course_buyers_text_hint = $meta_data['course_buyers_text_hint'] ?: "تعداد دانشجویان";
$course_buyers_text_icon = $meta_data['course_buyers_text_icon'] ?: "fal fa-users";

$product_category_border = codebean_option('product_category_border', false);
$image_size = codebean_option('shop_pro_image_size', 'studiare-course-thumb');
$sc_shop_page_addtocart = codebean_option('sc_shop_page_addtocart', false);
$sc_shop_page_qv = codebean_option('sc_shop_page_qv', false);
$sc_shop_page_aw = codebean_option('sc_shop_page_aw', false);
$product_stars = codebean_option('product_stars', true);
$show_stars = codebean_option('product_rating_view', true);
$archive_teacher_view = codebean_option('archive_teacher_view', 'list');
$product_descr_shop_page = codebean_option('product_descr_shop_page', false);
$product_danshjou_icon_view = codebean_option('product_danshjou_icon_view', false);
$danshjou_icon = codebean_option('danshjou_icon', 'fal fa-users');
$free_or_call_for_price = codebean_option('free_or_call_for_price', false);

//since version 13.2
$product_no_image = codebean_option('product_no_image', false)?:"default";
?>

<div <?php wc_product_class('course-item'); ?>>
    <?php 
    /* get product category color */
    $borderStyle = '';
    if ($product_category_border) {
        $terms = wp_get_post_terms(get_the_ID(), 'product_cat', ['fields' => 'ids']);
        if (!empty($terms)) {
            $cat_id = (int) $terms[0]; 
            $cat_color = get_term_meta($cat_id, 'sc_studi_cat_color', true);
            $cat_color = sanitize_hex_color($cat_color ?: '#26a69a');
            $borderStyle = sprintf("style='border-bottom: 4px solid %s !important;'", $cat_color);
        }
    }
    ?>

    <div class="course-item-inner" <?php echo $borderStyle; ?>>
        <?php //if (has_post_thumbnail()) : ?>
            <div class="course-thumbnail-holder">
                <?php 
                sc_studi_add_discount();
                sc_studi_add_comingsoon_badge();
                sc_studi_add_full_capacity_badge();
                ?>

                <?php woocommerce_template_loop_product_link_open(); ?>
                    <span class="image-item">
                        <?php //the_post_thumbnail($image_size, ['class' => 'img-fluid']); ?>
                        <?php 
                            if (has_post_thumbnail()) {
                                the_post_thumbnail($image_size, ['class' => 'img-fluid']);
                            } else {
                                if($product_no_image=='default'){
                                    // Your default image with same classes
                                    $default_image_url = get_template_directory_uri().'/assets/images/noimage.jpg';
                                }
                                if($product_no_image=='custom'){
                                    $default_image_url = codebean_option('product_no_image_custom', false)?:"";
                                    //print_r($default_image_url);
                                    if($default_image_url){
                                        $default_image_url = $default_image_url['thumbnail'];
                                    }
                                }
                                if($product_no_image!='noimage' && !empty($default_image_url)){
                                    echo '<img src="' . esc_url($default_image_url) . '" class="img-fluid" alt="' . esc_attr(get_the_title()) . '" />';
                                }
                            }
?>
                    </span>

                    <?php 
                    $current_user = wp_get_current_user();
                    $can_add_to_cart = true;
                    if ($current_user && wc_customer_bought_product($current_user->user_email, $current_user->ID, $product->get_id())) {
                        $can_add_to_cart = false;
                    }

                    if ($sc_shop_page_addtocart && $can_add_to_cart && $product->is_purchasable() && $product->is_in_stock()) {
                    echo apply_filters('woocommerce_loop_add_to_cart_link',
                        sprintf(
                            '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-toast-title="%s" data-toast-message="%s" data-toast-type="success" class="studi_add_in_shop %s product_type_%s ajax_add_to_cart"><i class="fal fa-shopping-basket"></i></a>',
                            esc_url($product->add_to_cart_url()),
                            esc_attr($product->get_id()),
                            esc_attr($product->get_sku()),
                            esc_attr__('Added to Cart', 'studiare'),
                            esc_attr(sprintf(__('Product "%s" has been added to your cart!', 'studiare'), $product->get_name())),
                            $product->is_purchasable() ? 'add_to_cart_button' : '',
                            esc_attr($product->get_type())
                        ),
                        $product
                    );
                } elseif ($sc_shop_page_addtocart) {
                        echo '<a href="' . get_permalink() . '" rel="nofollow" class="studi_add_in_shop"><i class="fal fa-shopping-basket"></i></a>';
                    }

                    if ($sc_shop_page_qv || $sc_shop_page_aw) : ?>
                        <div class="sc-buttons-sq-sw">
                            <?php if ($sc_shop_page_qv && shortcode_exists('woosq')) : ?>
                                <?php echo do_shortcode('[woosq]'); ?>
                            <?php endif; ?>
                            <?php if ($sc_shop_page_aw && shortcode_exists('woosw')) : ?>
                                <?php echo do_shortcode('[woosw]'); ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php woocommerce_template_loop_product_link_close(); ?>
            </div>
        <?php //endif; ?>

        <div class="course-content-holder sc_equal_height_item">
            <div class="course-content-main">
                <h4 class="course-title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h4>
                <?php if ($sc_course_type_selector == 2) : ?>
                    <div class="course-loop-element__course-type course-loop-element__course-type--onsite"><?php echo esc_html($sc_course_type_title_2); ?></div>
                <?php elseif ($sc_course_type_selector == 1) : ?>
                    <div class="course-loop-element__course-type course-loop-element__course-type--online"><?php echo esc_html($sc_course_type_title_1); ?></div>
                <?php endif; ?>

                <div class="course-rating-teacher">
                    <?php 
                    $product_stars = true;
                    $show_stars = true;
                    $archive_teacher_view = 'list';

                    if (class_exists('Redux')) {
                        $product_stars = codebean_option('product_stars', true);
                        $show_stars = codebean_option('product_rating_view', true);
                        $archive_teacher_view = codebean_option('archive_teacher_view', 'list');
                    }

                    $st_icon = $product_stars ? '' : '<i class="fal fa-star"></i>';

                    if ($show_stars) : ?>
                        <div class="sc-rating"><?php echo $st_icon; ?><?php woocommerce_template_loop_rating(); ?></div>
                    <?php endif; ?>

                    <?php if (!empty($teachers) && $archive_teacher_view !== 'disable') : ?>
                        <div class="sc-teacher <?php echo $archive_teacher_view === 'avatar' ? 'teacher-avatar' : ''; ?>">
                            <?php 
                            $teacher_images = [];
                            foreach ($teachers as $teacher_id) {
                                $teacher_images[$teacher_id] = get_the_post_thumbnail_url($teacher_id, 'thumbnail');
                            }

                            $teacher_count = count($teachers);
                            $separator = '';

                            foreach ($teachers as $index => $teacher_id) {
                                if ($archive_teacher_view === 'list') {
                                    echo $separator;
                                    echo '<a href="' . esc_url(get_the_permalink($teacher_id)) . '" class="course-loop-teacher hint--top-right" aria-label="' . esc_attr__('View Profile', 'studiare') . '">' . esc_html(get_the_title($teacher_id)) . '</a>';
                                    $separator = $index < $teacher_count - 1 ? ($index === $teacher_count - 2 ? esc_html__(' and ', 'studiare') : esc_html__(', ', 'studiare')) : '';
                                } else { // avatar view
                                    echo '<a target="_blank" href="' . esc_url(get_the_permalink($teacher_id)) . '" class="course-loop-teacher hint--top-right" aria-label="' . esc_attr(get_the_title($teacher_id)) . '"><img src="' . esc_url($teacher_images[$teacher_id]) . '" alt="' . esc_attr(get_the_title($teacher_id)) . '"></a>';
                                }
                            }
                            ?>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if ($product_descr_shop_page) : ?>
                    <?php if (has_excerpt()) : ?>
                        <div class="course-description">
                            <?php 
                            if (!function_exists('vc_is_inline') || !vc_is_inline()) {
                                echo get_the_excerpt();
                            }
                            ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <?php 
            $show_main_feature = codebean_option('product_sc_loop_main_feature', false);
            if ($show_main_feature) { 
                if (!empty($sc_loop_main_feature) && !empty($sc_loop_main_feature_hint) && !empty($sc_loop_main_feature_icon)) {
                    ?>
                    <div class="course-content-mid">
                        <div class="course-info-unit-time hint--top" aria-label="<?php echo esc_html($sc_loop_main_feature_hint); ?>">
                            <div class="value"><i class="<?php echo substr($sc_loop_main_feature_icon, 0, 3) . " " . substr($sc_loop_main_feature_icon, 3); ?>"></i> <?php echo esc_html($sc_loop_main_feature); ?></div>
                        </div>
                    </div>
                    <?php
                } elseif (!empty($duration)) {
                    ?>
                    <div class="course-content-mid">
                        <div class="course-info-unit-time hint--top" aria-label="<?php echo esc_html($duration_hint); ?>">
                            <div class="value"><i class="fal fa-clock"></i> <?php echo esc_html($duration); ?></div>
                        </div>
                    </div>
                    <?php
                }
            } ?>

            <div class="course-content-bottom">
                <?php if ($product_danshjou_icon_view) {
                    $course_buyers_text_hint = $meta_data['course_buyers_text_hint'] ?: "تعداد دانشجویان";
                    $course_buyers_text_icon = $meta_data['course_buyers_text_icon'] ?: "fal fa-users";
                    $danshjou_icon = !empty($course_buyers_text_icon) ? substr($course_buyers_text_icon, 0, 3) . " " . substr($course_buyers_text_icon, 3) : $danshjou_icon;
                    ?>
                    <div class="course-students hint--top-left" aria-label="<?php echo esc_html($course_buyers_text_hint); ?>">
                        <i class="<?php echo $danshjou_icon; ?>"></i><span><?php 
                        $count = $product->get_total_sales();
                        $text = sprintf(_n('%s', '%s', $count, 'studiare'), number_format_i18n($count));
                        echo esc_html($text); 
                        ?></span>
                    </div>
                <?php } ?>
                <div class="course-price">
                <?php 
                $sc_spce = ' ';
                $price_output = '';
                $toman_as_image = codebean_option('toman_as_image', false);
                $currency_symbol = get_woocommerce_currency_symbol();
            
                $toman_output = '';
                if ($toman_as_image) {
                    $toman_output = '<span class="sc-toman-cur">' . $currency_symbol . '</span>';
                } else {
                    $toman_output = $currency_symbol;
                }
            
                if (!empty($sale_price) && $sale_price != '0') {
                    $regular_price = number_format($regular_price);
                    $sale_price = number_format($sale_price);
                    $price_output = '<span class="sc_reg_onsale_price">' . $regular_price . '</span>' . 
                                    '<span class="price-sale">' . 
                                    $sale_price . $sc_spce . $toman_output . '</span>';
                } elseif (!empty($regular_price) && $sale_price === '0') {
                    $regular_price = number_format($regular_price);
                    $price_output = '<span class="sc_reg_onsale_price">' . $regular_price . $sc_spce . $toman_output . '</span>' . 
                                    '<span class="price-sale">' . 
                                    esc_html__('Free Course!', 'studiare') . '</span>';
                } elseif (!isset($regular_price)) {
                    $price_output = '<span class="amount">' . esc_html__('Call for price', 'studiare') . '</span>';
                } elseif (!empty($regular_price) && $regular_price != '0') {
                    $regular_price = number_format($regular_price);
                    $price_output = '<span>' . $regular_price . $sc_spce . $toman_output . '</span>';
                } elseif ($product->is_type('grouped')) {
                    $children = $product->get_children();
                    $min_price = null;
                    $max_price = null;
            
                    if (!empty($children)) {
                        foreach ($children as $child_id) {
                            $child_product = wc_get_product($child_id);
                            if ($child_product && $child_product->is_purchasable()) {
                                $price = $child_product->get_price();
                                if ($price !== '' && $price > 0) {
                                    if ($min_price === null || $price < $min_price) {
                                        $min_price = $price;
                                    }
                                    if ($max_price === null || $price > $max_price) {
                                        $max_price = $price;
                                    }
                                }
                            }
                        }
                    }
            
                    if ($min_price !== null && $max_price !== null && $min_price == $max_price) {
                        $price_formatted = number_format($min_price);
                        $price_output = '<span>' . $price_formatted . $sc_spce . $toman_output . '</span>';
                    } elseif ($min_price !== null && $max_price !== null) {
                        $min_price_formatted = number_format($min_price);
                        $max_price_formatted = number_format($max_price);
                        $price_output = '<span class="hint--top-right" aria-label="' . esc_html__('Select Options', 'studiare') . '">' . 
                                        $min_price_formatted . $sc_spce . '-' . $sc_spce . $max_price_formatted . $sc_spce . $toman_output . '</span>';
                    } else {
                        $price_output = '<span class="amount">' . esc_html__('Call for price', 'studiare') . '</span>';
                    }
                } elseif ($product->is_type('variable')) {
                    $sc_reg_price = number_format($product->get_variation_price('min'));
                    $sc_reg_price_max = number_format($product->get_variation_price('max'));
                    if ($sc_reg_price == $sc_reg_price_max) {
                        $price_output = '<span>' . $sc_reg_price . $sc_spce . $toman_output . '</span>';
                    } else {
                        $price_output = '<span class="hint--top-right" aria-label="' . esc_html__('Select Options', 'studiare') . '">' . 
                                        $sc_reg_price . $sc_spce . '-' . $sc_spce . $sc_reg_price_max . $sc_spce . $toman_output . '</span>';
                    }
                } elseif ($regular_price == '0') {
                    $price_output = '<span class="price-free">' . esc_html__('Free Course!', 'studiare') . '</span>';
                } else {
                    $price_output = $free_or_call_for_price ? 
                        '<span class="price-free">' . esc_html__('Free Course!', 'studiare') . '</span>' : 
                        '<span class="amount">' . esc_html__('Call for price', 'studiare') . '</span>';
                }
            
                echo $price_output;
                ?>
            </div>
            </div>
        </div>
    </div>
</div>