<?php
/**
 * Template Name: Single Quiz
 * Description: Displays a single quiz post with time-based access control.
 */
get_header(); ?>

<div class="main-page-content default-margin" id="content">

	<div class="site-content-inner container" role="main">
    <div class="blog-loop-inner post-single">
        <div class="post post-inner">
    <div class="quiz-content">
        <?php
        if (have_posts()) {
            while (have_posts()) : the_post();
                if (get_post_type() === 'sc-quiz') {
                    if (shortcode_exists('studiare_quiz')) {
                        echo do_shortcode('[studiare_quiz id="' . esc_attr(get_the_ID()) . '"]');
                    } else {
                        echo '<p>' . esc_html__('Quiz functionality is not available. Please check if the plugin is active.', 'studiare') . '</p>';
                    }
                } else {
                    echo '<p>' . esc_html__('This page is not a valid quiz.', 'studiare') . '</p>';
                }
            endwhile;
        } else {
            echo '<p>' . esc_html__('No quiz found.', 'studiare') . '</p>';
        }
        ?>
    </div>
    </div>
    </div>
    </div>
</div>

<?php get_footer(); ?>