<?php
namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Sc_Default_Dashboard extends Widget_Base {

    public function get_name() {
        return 'sc-default-dashboard';
    }

    public function get_title() {
        return __('Default Dashboard', 'studiare');
    }

    public function get_icon() {
        return 'sc eicon-dashboard';
    }

    public function get_categories() {
        return ['studiare-woocommerce'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Default Dashboard', 'studiare'),
            ]
        );

        $this->add_control(
            'description_note',
            [
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => __('This widget displays the default information of the WooCommerce account dashboard page. It only works on the account page.', 'studiare'),
                'content_classes' => 'elementor-descriptor',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        if (function_exists('is_account_page') && is_account_page()) {
            echo do_shortcode('[default_dashboard]');
        }
    }

    protected function content_template() {
        ?>
        <# if ( window.elementorFrontend.isEditMode() ) { #>
            <div class="elementor-widget-placeholder">
                <?php echo esc_html__('Default Dashboard (Visible only on WooCommerce account page)', 'studiare'); ?>
            </div>
        <# } else { #>
            {{{ '<?php if (function_exists("is_account_page") && is_account_page()) { echo do_shortcode("[default_dashboard]"); } ?>' }}}
        <# } #>
        <?php
    }
}