<?php
use Elementor\Core\DynamicTags\Data_Tag;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Studiare Logo Dynamic Tag
 */
class Studiare_Logo_Tag extends Data_Tag {
    
    public function get_name() {
        return 'studiare-custom-logo';
    }

    public function get_title() {
        return esc_html__('logo from studiare settings', 'studiare');
    }

    public function get_group() {
        return 'studiare';
    }

    public function get_categories() {
        return [\Elementor\Modules\DynamicTags\Module::IMAGE_CATEGORY];
    }

    protected function get_value(array $options = []) {
        // Default logo
        $default_logo = get_theme_file_uri('assets/images/logo_default.svg');
        $custom_logo_url = $default_logo;

        // Check if Redux is available and get the custom logo
        if (class_exists('Redux')) {
            $logo_uploaded = codebean_option('custom_logo_image');
            if (isset($logo_uploaded['url']) && !empty($logo_uploaded['url'])) {
                $custom_logo_url = $logo_uploaded['url'];
            }
        }

        // Get attachment ID from URL (if available)
        $attachment_id = attachment_url_to_postid($custom_logo_url);

        // Return image data
        return [
            'id'  => $attachment_id ? $attachment_id : 0,
            'url' => esc_url($custom_logo_url),
        ];
    }
}