<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://studiaretheme.ir
 * @since      1.0.0
 *
 * @package    Studiare_Dashboard_Notifications
 * @subpackage Studiare_Dashboard_Notifications
 */

class Studiare_Dashboard_Chat {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**<!-- phpDesigner :: Timestamp -->12/21/2023 9:41:58 AM<!-- /Timestamp -->
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
   
    public static function instance() {
            // Store the instance locally to avoid private static replication
            static $instance = null;
            // Only run these methods if they haven't been run previously
            if ( null === $instance ) {
                
                $instance = new Studiare_Dashboard_Chat();
  
            }
            // Always return the instance
            return $instance;
            // The last metroid is in captivity. The galaxy is at peace.
     }

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct() {

       add_action('wp_ajax_stc_delete_conversation', array($this , 'stc_delete_conversation'));
       
       
       add_action('wp_ajax_get_stc_gifts', array($this , 'get_stc_gifts'));
      
       add_action('plugins_loaded', array($this , 'setup_cache_groups'));
       
       
        add_action('wp_ajax_stc_message_search_users', array($this , 'stc_message_search_users'));
	}
    
    
    
    
    public function stc_message_search_users() {
        
              $defaults  = array(
                 'search' => ''
    		  );  
              $args = wp_parse_args( $_POST , $defaults );
            
           
              extract( $args );
              
              $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
            
              $errors = new WP_Error(); 
              
              $is_owner = stc_check_owner_conversation($thread_id);
              
              $thread_start = stc_check_start_conversation($thread_id);
              
          
              if ( ! $secure ) {
            		$errors->add(
                           'secure_miss',
                           esc_html('Some thing went wrong, try again','studiare-core')
                    );
                    wp_send_json_error( $errors );
              }
              
           
              $current_user_id = get_current_user_id();
             
              $search = isset($search) ? sanitize_text_field($search) : '';
              
               $user_query = new WP_User_Query(array(
                    'search' => '*' . esc_attr($search) . '*',
                    'search_columns' => array('user_login', 'user_email', 'display_name'),
                    'exclude' => array($current_user_id) 
                ));
               
               $users = $user_query->get_results();
               $results = [];
               
               
               
                foreach ($users as $user) {
                    $attach_id = get_user_meta( $user->ID, 'mm_sua_attachment_id', true ); 
                    $url = stc_avatar_default();
                    if($attach_id) {
                        $url = woodmart_otf_get_image_url( $attach_id , 'thumbnail' , '' , array( 'class' => 'ob_cover' ));
                    }
                    
                    $results[] = [
                        'id' => $user->ID,
                        'text' => $user->display_name,
                        'image' => $url 
                    ];
                }
                          
               wp_send_json_success(compact('results'));
   
	}
    
    
    
    
    public function setup_cache_groups() {
        
         wp_cache_add_global_groups( array(
			'stc_chat'
		) );
	
	
	}
 

        
       
      public function stc_delete_conversation() {  
  
               $defaults  = array(
                 'thread_id' => ''
    		  );  
              $args = wp_parse_args( $_POST , $defaults );
            
           
              extract( $args );
              
              $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
            
              $errors = new WP_Error(); 
              
              $is_owner = stc_check_owner_conversation($thread_id);
              
              $thread_start = stc_check_start_conversation($thread_id);
              
          
              if ( ! $secure || empty($thread_id) ) {
            		$errors->add(
                           'secure_miss',
                           esc_html('Some thing went wrong, try again','studiare-core')
                    );
                    wp_send_json_error( $errors );
              }
              
              if ( !$is_owner || !$thread_start ) {
            		$errors->add(
                           'is_owner',
                           esc_html('You do not have permission to accessx','studiare-core')
                    );
                    wp_send_json_error( $errors );
              }
              
              stc_delete_thread_and_related_data($thread_id);
   
              
           
              $message = esc_html__('You have deleted the conversation','studiare-core');
              
              wp_send_json_success(compact('message'));
        
      }
    
      
 
      
      
      public function get_stc_gifts() {
        
          $defaults  = array();  
          $args = wp_parse_args( $_POST , $defaults );
        
          extract( $args );
          
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 
          
          global $wpdb;
        
          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
          
          $args =  array(
                'post_type'         =>  'stc_gift',
                'post_status'       =>  array( 'publish' ),
                'posts_per_page'    =>  -1,
                'orderby'   => 'title', 
                'order'             =>  'ASC',
          );
          
         $posts = get_posts( $args );
         
         ob_start(); 
         
         if( $posts ){
        		foreach ( $posts as $post ){
        
                    $post_id = $post->ID;
                    $image = get_post_meta($post_id,'thumbnail',true);
                    $number_credits = get_post_meta($post_id,'number_credits',true);
       
                    
                    ?>
                    <div class="gift-item" data-id="<?php echo esc_attr($post_id); ?>">
                        <?php
                          
                               echo wp_get_attachment_image( $image, 'thumbnail' );
                        
                        ?>  
                        <h6><?php   printf( __( '%s Credits' , 'streamvid' ),$number_credits );  ?></h6>               
                    </div>
                    <?php
                }
         
                
         } else {
            
            ?>
             
             <div class="gift-item">
                                         
             </div>
            
            <?php
            
         }
         ?>
    
         <?php
    
        
         $result = ob_get_clean(); 
     
          wp_send_json_success(compact('result'));
        
      }
    
   
 
 
}    
function Studiare_Dashboard_Chat() {
    return Studiare_Dashboard_Chat::instance();
}
