var stcThemeMatchModule;
(function( $ ) {
	'use strict';
    
        window.show_notification = function ($content,$role) {
    
        function createCustomToast() {
            var toastContent = document.createElement("div");
            toastContent.innerHTML  = '<div class="mess-inner fs-small">'+$content+'</div>';
              return toastContent;
        }
        
        if($content) {
    
          var bg = '#438f3e';
          
          if($role == 'error') {
             bg = '#bf9537';
          }
          
               Toastify({
                node: createCustomToast(),
                duration: 4000,
                close:true,
                gravity:'bottom',
                position:'center',
                stopOnFocus:true,
                style: {
                    background:bg,
                },
              }).showToast();     
        }
    
        
    };
    
    stcThemeMatchModule = (function() {
        return {
            init: function() {
             this.discover_slider();
             this.address_search();
             this.unskip();
        },
   
    
          
        address_search:function() {
            
      
					var input = '.member-place';
                    var inputElement = document.querySelector(input);
                    if (inputElement) {
					google.maps.event.addDomListener(document.querySelector(input), 'keydown', function(event) {
						if (event.keyCode === 13) {
							event.preventDefault();
						}
					});

					if ( document.querySelector(input).value == 'a:0:{}' ) {
						document.querySelector(input).value = '';
					}

					var ppx_autocomplete = new google.maps.places.Autocomplete(
						(document.querySelector(input)), { 
							types: ['geocode'],
					
						});
						
					ppx_autocomplete.setFields(['geometry', 'formatted_address']);

					google.maps.event.addListener(ppx_autocomplete, 'place_changed', function () {

						var place = ppx_autocomplete.getPlace();

						document.querySelector(input).value = place.formatted_address;

					
						var lat = place.geometry.location.lat();
						var lng = place.geometry.location.lng();
						var latlng = lat + ',' + lng;
						document.querySelector('.member-place-hidden').value = latlng;
					
					});
                }
	   },
       
       
       
       unskip:function() { 
        
            $(document).on('click', '.stc-unmatch-skip' , function(e) { 
        
                    e.preventDefault();    
                    var  button = $(this), 
                    item = button.parents('.stc_members_item'), 
                    id = button.data('id'), 
                    nonce = stc_match.stc_nonce,
                    data = {}; 
                    
                    button.addClass('loading');
      
                    data.action = 'stc_match_unskip'
                    data.id = id;
                    data.nonce = nonce;
                    
                    stcThemeModule.global_loading(button);
            
                    $.ajax({
                        url: stc_match.ajax_url,
            			data: data,
            			type: 'POST',
                        dataType: 'json',
                        success: function(response) {
                  
                            console.log(response);
          
                             if(response.success) { 
                                
                                show_notification(response.data.message,'success');
                                if($('body').hasClass('removed-profile')) item.remove();
                             } else {
                                
                                show_notification(response.data[0].message,'error');
                                
                             }
                            				
                        },
                        error: function() {
                            console.log('error');
                        },
                        complete: function() {button.removeClass('loading')},
                  });
                
            });
         
       },
        
        
       discover_slider:function() {
            
               
                if($('.stc-match-discover').length) {
                    
                     var options = {
                            effect: "cards",
                            grabCursor: true,
                            allowTouchMove: false,
                            speed:1000,
                            
                        };
                   
                     var swiper = new Swiper(".swiper-discover", options );
              }
              
            $(document).on('click', '.stc-match-like' , function(e) { 
                    e.preventDefault();    
                    var  button = $(this),  
                    id = button.data('id'), 
                    nonce = stc_match.stc_nonce,
                    data = {}; 
                    button.addClass('loading');
     
                    data.action = 'stc_match_like'
                    data.id = id;
                    data.nonce = nonce;
                    stcThemeModule.global_loading(button);
                    $.ajax({
                        url: stc_match.ajax_url,
            			data: data,
            			type: 'POST',
                        dataType: 'json',
                        success: function(response) {
                             
                             if($('.stc-match-discover').length) { 
                              
                             
                                 var currentIndex = swiper.realIndex;
                       
                                 var slideToRemove = currentIndex - 1;
                               
                                    
                                  swiper.slideNext(); 
                                 
                                 if(currentIndex == 0) {
                                    slideToRemove = 0;
                                 }
                                 
                                setTimeout(function() { 
                                    
                                    swiper.removeSlide(slideToRemove);
                           
                                    
                                }, 300);
                            
                            
                            }
                             
                             button.removeClass('liked');  
                             if(response.success) { 
                                
                                show_notification(response.data.message,'success');
                                if(!button.hasClass('liked')){
                                    console.log('exist');
                                  button.addClass('liked');  
                                }
                                
                             } else {
                                
                                show_notification(response.data[0].message,'error');
                                
                             }
                            				
                        },
                        error: function() {
                            console.log('error');
                        },
                        complete: function() {button.removeClass('loading')},
                  });
     
            });
              
            $(document).on('click', '.stc-match-skip' , function(e) { 
        
                    e.preventDefault();    
                    var  button = $(this),  
                    id = button.data('id'), 
                    nonce = stc_match.stc_nonce,
                    data = {}; 
                    
                    button.addClass('loading');
      
                    data.action = 'stc_match_skip'
                    data.id = id;
                    data.nonce = nonce;
                    
                    stcThemeModule.global_loading(button);
            
                    $.ajax({
                        url: stc_match.ajax_url,
            			data: data,
            			type: 'POST',
                        dataType: 'json',
                        success: function(response) {
                            
                              
                             if($('.stc-match-discover').length) { 
                              
                             
                             var currentIndex = swiper.realIndex;
                   
                             var slideToRemove = currentIndex - 1;
                           
                                
                              swiper.slideNext(); 
                             
                             if(currentIndex == 0) {
                                slideToRemove = 0;
                             }
                             
                            setTimeout(function() { 
                                
                                swiper.removeSlide(slideToRemove);
                       
                                
                            }, 300);
                            
                            
                            }
                         
                             if(response.success) { 
                                
                                show_notification(response.data.message,'success');
                                
                                button.parents('.stc_members_item').remove();
                                
                              
                                if(button.parents('.stc-match-discover').find('.swiper-slide').length - 1 < 1) {
                                     var url = window.location.href;
                                     $(document.body).trigger('studiare-core_catelog_filter_ajax', [url, $(this)]);
                                }
                               
                                
                             } else {
                                
                                show_notification(response.data[0].message,'error');
                                
                             }
                            				
                        },
                        error: function() {
                            console.log('error');
                        },
                        complete: function() {button.removeClass('loading')},
                  });
                
            });
        
            
            
        },
       }; // End return
        
    }());
     
     
    $(document).ready(function() {
        stcThemeMatchModule.init();
    });
        
})( jQuery );       