<?php
/**
 * The Download Custom Post Type
 */

if ( !defined( 'ABSPATH' ) )
	die( '-1' );

if ( ! class_exists( 'Studiare_Studi_Footer' ) ) {

	class Studiare_Studi_Footer {

		public static $instance;

		// Setup a single instance using the singleton pattern
		public static function init() {

			if ( is_null( self::$instance ) ) {
				self::$instance = new Studiare_Studi_Footer();
			}
			return self::$instance;

		}

		function __construct() {

			add_action( 'init', array($this, 'register_post_type' ), 5 );
			/*add_action( 'cmb2_admin_init', array($this,'register_meta_boxes' ));*/

			if( is_admin() ) {

				add_filter( 'manage_edit-teacher_columns' , array( $this,'add_studi_footer_columns' ) );
				add_action( 'manage_teacher_posts_custom_column' , array( $this,'set_teacher_columns_content' ), 10, 2 );

			}
		}

		function register_post_type() {

			$options = get_option( 'studiare-core-options' );

			if ( post_type_exists( 'studi_footer' ) ) {
				return;
			}

			$labels = array(
				'name'                => _x( 'پاورقی استادیار', 'Post Type General Name', 'studiare-core' ),
				'singular_name'       => _x( 'پاورقی', 'Post Type Singular Name', 'studiare-core' ),
				'menu_name'           => __( 'پاورقی استادیار', 'studiare-core' ),
				'parent_item_colon'   => __( 'پاورقی والد:', 'studiare-core' ),
				'all_items'           => __( 'همه پاورقی ها', 'studiare-core' ),
				'view_item'           => __( 'مشاهده', 'studiare-core' ),
				'add_new_item'        => __( 'افزودن جدید', 'studiare-core' ),
				'add_new'             => __( 'افزودن جدید', 'studiare-core' ),
				'edit_item'           => __( 'ویرایش پاورقی', 'studiare-core' ),
				'update_item'         => __( 'بروزرسانی پاورقی', 'studiare-core' ),
				'search_items'        => __( 'جستجوی پاورقی', 'studiare-core' ),
				'not_found'           => __( 'یافت نشد', 'studiare-core' ),
				'not_found_in_trash'  => __( 'در سطل زباله یافت نشد', 'studiare-core' ),
			);

			$rewrite = array(
				'slug'                => 'studi_footer', // $options['studi_footer-slug'],
				'with_front'          => false,
			);

			$args = array(
				'label'               => __( 'footer', 'studiare-core' ),
				'description'         => __( 'Footer Post Type', 'studiare-core' ),
				'labels'              => $labels,
				// 'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
				'supports'            => array( 'title', 'editor' ),
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
            'show_in_menu'       => 'studiare_panel',
				'show_in_nav_menus'   => false,
				'show_in_admin_bar'   => false,
				'menu_position'       => 22,
				'can_export'          => true,
				'has_archive'         => true,
				'exclude_from_search' => true,
				'publicly_queryable'  => true,
				'query_var'           => true,
				'rewrite'             => $rewrite,
				'menu_icon'           => 'dashicons-tagcloud',
				'capability_type'     => 'post',
			);

			register_post_type( 'studi_footer', $args );

		}

		function register_meta_boxes() {

			$prefix = '_studiare_';

			$studi_footer_metaboxes = new_cmb2_box( array(
				'id'           => 'studi_footer_metabox',
				'title'        => esc_html__( 'اطلاعات پاورقی', 'studiare' ),
				'object_types' => array( 'studi_footer' ),
				'context'      => 'normal',
				'priority'     => 'high',
				'show_names'   => true,
			) );

			

			$studi_footer_metaboxes->add_field( array(
				'name' => esc_html__( 'لینک فایل', 'studiare' ),
				'id' => 'file_url',
				'type' => 'file',
			) );

			
			
		}

		function add_studi_footer_columns( $cols ) {

			$cols = array(
				'cb'        =>   '<input type="checkbox" />',
				'title'     => __( 'عنوان', 'studiare-core' ),
				'thumbnail' => __( 'Thumbnail', 'studiare-core')
			);

			return $cols;

		}

		function set_teacher_columns_content( $column, $post_id ) {

			$width = (int) 35;
			$height = (int) 35;

			switch( $column ) {

				case 'thumbnail' :
					$thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );
					$attachments = get_children( array('post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image') );

					if ( $thumbnail_id ) {
						$thumb = wp_get_attachment_image( $thumbnail_id, array($width, $height), true );
					} elseif ( $attachments ) {
						foreach ( $attachments as $attachment_id => $attachment ) {
							$thumb = wp_get_attachment_image( $attachment_id, array($width, $height), true );
						}
					}

					if ( isset( $thumb ) && $thumb ) {
						echo wp_kses_post( $thumb );
					} else {
						echo __('None', 'educa-addons');
					}

					break;

			}

		}

	}

	Studiare_Studi_Footer::init();
}
